﻿/*	
VERSION: 		1.1

USAGE: 
	#include "functions/detectMouseHitTest.as"
	var detect = detectMouseHitTest( my_btn );
	
	detect.hover = function(){
		trace("detect.hover()");
	}// hover()
	detect.unHover = function(){
		trace("detect.unHover()");
	}// unHover()
	
*/



function detectMouseHitTest( this_mc, in_everyFrame ){
	var _this = this;
	#include "eventSystem3.as"
		// sendEvent.as
	
	var in_everyFrame = Boolean( in_everyFrame );		// whether to check every frame,  or only when the mouse moves
	var checkOnFrame = in_everyFrame;
	var checkOnMouseMove = !in_everyFrame;
	
	// chain interface
	var output = {};
		// hover()			// externally defined
		// unHover()		// externally defined
	
	var react = make_react( this_mc );		// param is optional
	
	var wasHovered = false;
	var frameInterval = null;
	var setTimeout;
	var clearTimeout;
	var clearInterval;
	
	
	function hover(){
		output.hover.apply( output, [this_mc] );
	}// hover()
	
	
	function unHover(){
		output.unHover.apply( output, [this_mc] );
	}// unHover()
	
	
	function updateMouse()
	{
		if( this_mc.visible === false )		return;
		if( this_mc.enabled === false )		return;
		if( this_mc._visible === false )	return;
		//  detect missing movieClip
		if( this_mc._currentframe === undefined ){
			react.unload();
			return;
		}
		
		var isHovered = this_mc.hitTest( _root._xmouse, _root._ymouse, false );
		
		if( isHovered  &&  !wasHovered )
		{// if:  unHover -> hover
			hover()
		}// if:  unHover -> hover
		else if( !isHovered  &&  wasHovered )
		{// if:  hover -> unHover
			unHover();
		}// if:  hover -> unHover
		
		wasHovered = isHovered;
	}// update()
	
	
	// check every frame()
	if( checkOnFrame ){
		frameInterval = setInterval( function(){
			updateMouse();
		}, 33 );
		react.to( "unload" ).then = function(){
			clearInterval( frameInterval );
		}// unload()
	}// check every frame()
	
	
	// check whenever the mouse moves()
	if( checkOnMouseMove ){
		react.to( "onMouseMove" ).from( Mouse ).then = updateMouse;		// attempt to call every time the mouse moves
	}// check whenever the mouse moves()
	
	return output;
}// detectHover()